CONTAINER fx_foam
{
	NAME fx_foam;
	INCLUDE Obase;

	//Basic Tab
	GROUP ID_OBJECTPROPERTIES
	{			
		DEFAULT 1;
		BOOL FOAM_RENDERONLY {}
		LONG FOAM_MODE
		{
			CYCLE
			{
			FOAM_MODE_EDIT;
			FOAM_MODE_ANIMATE;
			}
		}
		SEPARATOR {LINE;}

		LINK FOAM_SOLVER {ACCEPT{fx_fluidsim;}; }
		LINK FOAM_MESHER {ACCEPT{fx_fluidmesher;}; }
		LONG FOAM_SIZEX {MIN 10; }
		REAL FOAM_DENSITY { MIN 0.001; UNIT METER; STEP 0.01;}
		SEPARATOR {LINE;}
		LONG FOAM_SDF_CELLS { MIN 1; MAX 4; }
		LONG FOAM_SINGLECORE { MIN 0; MAX 256; }
		LONG FOAM_ITERATIONS { MIN 0; MAX 10; }

		GROUP FOAM_SID
		{
			BOOL FOAM_ON {}
			BOOL FOAM_OUTTOSPRAY {}
			BOOL FOAM_CLAMPTOFLUIDSIM {}
			REAL FOAM_OFFSET { MIN 0; STEP 0.001; }
			
			LINK FOAM_TARGET {ACCEPT{1001381;}; }
			REAL FOAM_CURVATURE { MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }
			
			SEPARATOR {LINE;}
			GROUP
			{
				COLUMNS 2; 
				REAL FOAM_VELOCITY { MIN 0; UNIT METER; }
				REAL FOAM_VELOCITYRND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL FOAM_VORTICITY { MIN 0; UNIT METER; }
				REAL FOAM_VORTICITYRND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL FOAM_AGE { MIN 1; STEP 1;}
				REAL FOAM_AGERND { MIN 0; MAX 100; UNIT PERCENT;}
			}
		}
		
		GROUP SPRAY_SID
		{
			BOOL SPRAY_ON {}
			BOOL SPRAY_OUTTOFOAM {}
			BOOL SPRAY_CLAMPTOFLUIDSIM {}
			
			BUTTON SPRAY_ADDSOLVER {}
			LINK SPRAY_SOLVER {ACCEPT{fx_fluidsim; fx_particle; 1001381;}; }
			REAL SPRAY_CURVATURE { MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }
			
			SEPARATOR {LINE;}

			GROUP
			{
				COLUMNS 2; 
				REAL SPRAY_VELOCITY { MIN 0; UNIT METER; }
				REAL SPRAY_VELOCITYRND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL SPRAY_VORTICITY { MIN 0; UNIT METER; }
				REAL SPRAY_VORTICITYRND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL SPRAY_AGE { MIN 1; STEP 1;}
				REAL SPRAY_AGERND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL SPRAY_SPEED { MIN 0; STEP 0.01; }
				REAL SPRAY_SPEEDRND { MIN 0; MAX 100; UNIT PERCENT;}
				REAL SPRAY_SPEEDN {MIN 0; UNIT METER; }
				REAL SPRAY_SPEEDNRND { MIN 0; MAX 100; UNIT PERCENT;}
			}
		}
	}	
}